package ru.yandex.chemodan.app.datasyncadmin.admin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.web.admin.AccessRoutines;
import ru.yandex.chemodan.boot.admin.CustomAdminActionInterceptorsHolder;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;

/**
 * @author yashunsky
 */
public class CheckAccessInterceptorsHolder implements CustomAdminActionInterceptorsHolder {

    private final AccessRoutines accessRoutines;

    public CheckAccessInterceptorsHolder(AccessRoutines accessRoutines) {
        this.accessRoutines = accessRoutines;
    }

    @Override
    public ListF<ActionInvocationInterceptor> getInterceptors() {
        return Cf.list(new CheckAccessInvocationInterceptor(accessRoutines));
    }
}
