package ru.yandex.chemodan.app.datasyncadmin.admin;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.web.admin.AccessRoutines;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.result.error.ErrorResult;
import ru.yandex.commune.a3.utils.Ordered;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author yashunsky
 */
public class CheckAccessInvocationInterceptor implements ActionInvocationInterceptor {
    private final static ListF<String> ALLOWED_PREFIXES = Cf.list("/info", "/user-databases", "/database-info");

    private final AccessRoutines accessRoutines;

    public CheckAccessInvocationInterceptor(AccessRoutines accessRoutines) {
        this.accessRoutines = accessRoutines;
    }

    private boolean prefixIsAllowed(Option<String> pathInfo) {
        return !pathInfo.isPresent() || pathInfo.get().equals("/")
                || ALLOWED_PREFIXES.exists(pathInfo.get()::startsWith);
    }

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        HttpServletRequestX req = invocation.getWebRequest().getHttpServletRequest();

        boolean isSuperuser = accessRoutines.isSuperUser(req);

        Option<String> pathInfo = req.getPathInfoO();
        if (isSuperuser || prefixIsAllowed(pathInfo)) {
            return invocation.invoke();
        }
        return new ErrorResult("Access denied", "You are not allowed to see this page");
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
