package ru.yandex.chemodan.app.datasyncadmin.databases;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;

import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.client.ZkManager;

/**
 * @author yashunsky
 */
public class AccessibleDatabasesContextConfiguration {
    @Bean
    public DatabasesRegistry databasesRegistry(@Qualifier("zkRoot") ZkPath zkRoot, ZkManager zkManager) {
        DatabasesRegistry registry = new DatabasesRegistry(zkRoot.child("datasync-admin-databases"));

        zkManager.addClient(registry);
        return registry;
    }

    @Bean
    public DatabasesRoutines databasesRoutines(DatabasesRegistry registry) {
        return new DatabasesRoutines(registry);
    }
}
