package ru.yandex.chemodan.app.datasyncadmin.databases;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;

/**
 * @author yashunsky
 */
public class DatabasesRoutines {
    private final DatabasesRegistry registry;

    public DatabasesRoutines(DatabasesRegistry registry) {
        this.registry = registry;
    }

    public synchronized void addDbs(String appId, ListF<String> dbs) {
        registry.put(new AppDbs(appId, registry.getO(appId).isPresent()
                ? registry.get(appId).dbs.plus(dbs).unique().toList()
                : dbs));
    }

    public void addDb(String appId, String db) {
        addDbs(appId, Cf.list(db));
    }

    public synchronized int removeDbs(String appId, ListF<String> dbs) {
        if (registry.getO(appId).isPresent()) {
            ListF<String> before = registry.get(appId).dbs;
            ListF<String> after = before.filterNot(dbs::containsTs);

            if (after.isEmpty()) {
                registry.remove(appId);
            } else {
                registry.put(new AppDbs(appId, after));
            }

            return before.size() - after.size();
        } else {
            return 0;
        }
    }

    public boolean removeDb(String appId, String db) {
        return removeDbs(appId, Cf.list(db)) == 1;
    }
}
