package ru.yandex.chemodan.app.datasyncadmin.idm;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.web.admin.AccessLevel;
import ru.yandex.chemodan.app.dataapi.web.admin.AccessRoutines;
import ru.yandex.chemodan.app.datasyncadmin.users.UserAccess;
import ru.yandex.chemodan.app.datasyncadmin.users.UsersRegistry;
import ru.yandex.chemodan.util.auth.YateamAuthUtils;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author yashunsky
 */
public class IdmAccessRoutines implements AccessRoutines {
    private final UsersRegistry usersRegistry;

    public IdmAccessRoutines(UsersRegistry usersRegistry) {
        this.usersRegistry = usersRegistry;
    }

    private Option<UserAccess> getAccess(HttpServletRequestX req) {
        return YateamAuthUtils.getLoginFromAttributeO(req).filterMap(usersRegistry::getO);
    }

    private Option<AccessLevel> getAccessLevel(
            String app, String databaseId, MapF<Tuple2<String, String>, AccessLevel> accessMap)
    {
        return accessMap.getO(Tuple2.tuple(app, databaseId))
                .plus(accessMap.getO(Tuple2.tuple(app, IdmRegistriesRoutines.ALL_DBS_MARKER))).maxO();
    }

    private boolean isAccessible(
            String app, String databaseId, AccessLevel minLevel, MapF<Tuple2<String, String>, AccessLevel> accessMap)
    {
        return getAccessLevel(app, databaseId, accessMap).map(level -> level.contains(minLevel)).containsTs(true);
    }

    private String getAppName(Option<String> appName) {
        return appName.getOrElse(".global");
    }

    @Override
    public ListF<Database> filterAccessibleByRequest(HttpServletRequestX req, ListF<Database> databases) {
        Option<UserAccess> accessO = getAccess(req);

        if (!accessO.isPresent()) {
            return Cf.list();
        }

        if (accessO.get().superuser) {
            return databases;
        }

        MapF<Tuple2<String, String>, AccessLevel> accessMap = accessO.get().getDbAccessesAsMap();

        return databases.filter(db -> isAccessible(
                getAppName(db.appNameO()), db.dbRef().databaseId(), AccessLevel.VIEW_META, accessMap));
    }

    @Override
    public Option<AccessLevel> getAccessByRequest(HttpServletRequestX req, Option<String> app, String databaseId) {
        Option<UserAccess> accessO = getAccess(req);

        if (!accessO.isPresent()) {
            return Option.empty();
        }

        if (accessO.get().superuser) {
            return Option.of(AccessLevel.EDIT);
        }

        return getAccessLevel(getAppName(app), databaseId, accessO.get().getDbAccessesAsMap());
    }

    @Override
    public boolean isSuperUser(HttpServletRequestX req) {
        return getAccess(req).map(UserAccess::isSuperuser).getOrElse(false);
    }
}
