package ru.yandex.chemodan.app.datasyncadmin.users;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.chemodan.app.dataapi.web.admin.AccessLevel;
import ru.yandex.chemodan.app.datasyncadmin.idm.IdmRegistriesRoutines;
import ru.yandex.chemodan.util.idm.RoleSpecification;
import ru.yandex.chemodan.util.idm.UserRoles;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author yashunsky
 */
@BenderBindAllFields
public class UserAccess extends DefaultObject {
    public final String login;
    public final ListF<DbAccess> dbAccesses;
    public final boolean superuser;

    public UserAccess(String login, ListF<DbAccess> dbAccesses, boolean superuser) {
        this.login = login;
        this.dbAccesses = dbAccesses;
        this.superuser = superuser;
    }

    public static UserAccess empty(String login) {
        return new UserAccess(login, Cf.list(), false);
    }

    public UserAccess withSuperuser(boolean superuser) {
        return new UserAccess(login, dbAccesses, superuser);
    }

    public UserAccess withAccess(DbAccess access) {
        return new UserAccess(login, dbAccesses.plus1(access).unique().toList(), superuser);
    }

    public UserAccess withoutAccess(DbAccess access) {
        return new UserAccess(login, dbAccesses.filterNot(access::equals), superuser);
    }

    public String getLogin() {
        return login;
    }

    public UserRoles getUserRoles() {
        ListF<RoleSpecification> roles = dbAccesses
                .map(IdmRegistriesRoutines::getRoleSpecification)
                .plus(superuser ? Option.of(IdmRegistriesRoutines.SUPERUSER_ROLE) : Option.empty());

        return new UserRoles(login, roles);
    }

    public MapF<Tuple2<String, String>, AccessLevel> getDbAccessesAsMap() {
        return dbAccesses.groupBy(dbAccess -> Tuple2.tuple(dbAccess.appId, dbAccess.dbId))
                .mapValues(accesses -> accesses.map(a -> a.access).max());
    }

    public boolean isSuperuser() {
        return superuser;
    }
}
