package ru.yandex.chemodan.app.datasyncadmin.web;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.util.idm.IdmUtils;
import ru.yandex.chemodan.util.idm.RoleSpecificationConverter;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.chemodan.util.web.SuppressInvocationInfoJsonPojoResultSerializer;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.ActionConfigurationBuilder;
import ru.yandex.commune.a3.ActionConfigurator;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.CloneableAction;
import ru.yandex.commune.a3.action.parameter.convert.DefaultConverters;
import ru.yandex.commune.a3.action.result.AddCommonAttributesInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.SimpleResultSerializer;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.spring.ApplicationContextUtils;

/**
 * @author yashunsky
 */
public class WebContextConfiguration {

    @Bean
    public ActionApp actionApp(ApplicationContext context, ApplicationInfo applicationInfo) {

        ListF<CloneableAction> cloneableActions = ApplicationContextUtils
                .beansOfType(context, CloneableAction.class);

        ListF<Object> actionContainers = ApplicationContextUtils
                .beansWithAnnotationList(context, ActionContainer.class)
                .get2();

        ActionConfigurationBuilder builder = ActionConfigurationBuilder
                .cons(applicationInfo)
                .setConverters(DefaultConverters.all().getConverters().plus1(new RoleSpecificationConverter()))

                .setResultSerializers(Cf.list(
                        new SimpleResultSerializer(),
                        new SuppressInvocationInfoJsonPojoResultSerializer(IdmUtils.mapper)))

                .setParameterBinders(Cf.list(
                        new BenderJsonParameterBinder(new BenderMapper())))

                .setInvocationInterceptors(Cf.list(
                        new AddCommonAttributesInterceptor(applicationInfo)))

                .setResultType(MediaType.APPLICATION_JSON);

        return ActionConfigurator.configure(actionContainers.plus(cloneableActions), builder);
    }
}
