package ru.yandex.chemodan.app.dataapi;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.web.DataapiRequestAppHolder;
import ru.yandex.commune.a3.action.intercept.ActionInvocationInterceptor;
import ru.yandex.commune.a3.action.invoke.ActionInvocation;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.utils.Ordered;

public class AppInfoInvocationInterceptor implements ActionInvocationInterceptor {

    @Override
    public Object intercept(ActionInvocation invocation) throws Exception {
        try (AutoCloseable ctx = openContext(invocation)) {
            Object result = invocation.invoke();
            return result;
        }
    }

    private static AutoCloseable openContext(ActionInvocation invocation) {
        getAppParameterValue(invocation.getWebRequest()).ifPresent(DataapiRequestAppHolder::set);
        return () -> DataapiRequestAppHolder.remove();
    }

    private static Option<String> getAppParameterValue(WebRequest request) {
        return request.getParameter("app").firstO();
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }
}
