package ru.yandex.chemodan.app.dataapi;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.api.db.ref.SpecialDatabases;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesContextConfiguration;
import ru.yandex.chemodan.app.dataapi.apps.AppsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.DatabasesContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.dao.DataApiUserMetaContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.dao.JdbcShardContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.dump.YtDumpContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.xiva.DataApiXivaContextConfiguration;
import ru.yandex.chemodan.app.dataapi.utils.elliptics.EllipticsContextConfiguration;
import ru.yandex.chemodan.util.jdbc.JdbcDatabaseConfiguratorContextConfiguration;
import ru.yandex.chemodan.util.sharpei.SharpeiCachingManager;
import ru.yandex.commune.dynproperties.DynamicPropertyManager;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        AppsContextConfiguration.class,
        DataApiUserMetaContextConfiguration.class,
        DatabasesContextConfiguration.class,
        EllipticsContextConfiguration.class,
        ExternalDatabasesContextConfiguration.class,
        JdbcDatabaseConfiguratorContextConfiguration.class,
        JdbcShardContextConfiguration.class,
        DataApiXivaContextConfiguration.class,
        YtDumpContextConfiguration.class,
})
public class DataApiBaseContextConfiguration {

    @Autowired
    private DynamicPropertyManager dynamicPropertyManager;

    @PostConstruct
    public void init() {
        dynamicPropertyManager.addStaticFields(SpecialDatabases.class);
        dynamicPropertyManager.addStaticFields(SharpeiCachingManager.class);
    }
}
