package ru.yandex.chemodan.app.dataapi;

import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.format.ISODateTimeFormat;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldMarshallerUnmarshaller;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChangeMarshallerUnmarshaller;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChangeMarshallerUnmarshaller;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.BenderSettings;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactory;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;
import ru.yandex.misc.bender.custom.DateTimeConfigurableUnmarshaller;
import ru.yandex.misc.bender.custom.DurationAsMillisMarshaller;
import ru.yandex.misc.bender.custom.DurationAsMillisUnmarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisMarshaller;
import ru.yandex.misc.bender.custom.InstantAsMillisUnmarshaller;
import ru.yandex.misc.bender.custom.ReadableInstantConfigurableMarshaller;

/**
 * @author tolmalev
 */
public class DataApiBenderUtils {

    public static BenderMapper mapper() {
        return new BenderMapper(getConfig());
    }

    public static BenderConfiguration getConfig() {
        return new BenderConfiguration(new BenderSettings(),
                marshallerUnmarshallerFactory());
    }

    private static CustomMarshallerUnmarshallerFactory marshallerUnmarshallerFactory() {
        return marshallerUnmarshallerFactoryBuilder()
                .build();
    }

    public static CustomMarshallerUnmarshallerFactoryBuilder marshallerUnmarshallerFactoryBuilder() {
        return CustomMarshallerUnmarshallerFactoryBuilder
                .cons()
                .add(Duration.class,
                        new DurationAsMillisMarshaller(),
                        new DurationAsMillisUnmarshaller())
                .add(Instant.class,
                        new InstantAsMillisMarshaller(),
                        new InstantAsMillisUnmarshaller())
                .add(DataField.class,
                        new DataFieldMarshallerUnmarshaller(),
                        new DataFieldMarshallerUnmarshaller())
                .add(RecordChange.class,
                        new RecordChangeMarshallerUnmarshaller(),
                        new RecordChangeMarshallerUnmarshaller())
                .add(FieldChange.class,
                        new FieldChangeMarshallerUnmarshaller(),
                        new FieldChangeMarshallerUnmarshaller())
                .add(DateTime.class,
                        new ReadableInstantConfigurableMarshaller(ISODateTimeFormat.dateTime()),
                        new DateTimeConfigurableUnmarshaller(ISODateTimeFormat.dateTimeParser().withOffsetParsed()));
    }
}
