package ru.yandex.chemodan.app.dataapi;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.web.ActionsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.web.ProxyConfiguration;
import ru.yandex.chemodan.app.dataapi.web.admin.DataApiCoreAdminContextConfiguration;
import ru.yandex.chemodan.dc.closing.AliveAppInfoHolder;
import ru.yandex.chemodan.http.proxy.ProxyPingLockWorkerService;
import ru.yandex.chemodan.util.ping.CoolPingServlet;
import ru.yandex.chemodan.util.web.A3JettyConfiguration;
import ru.yandex.chemodan.util.web.A3JettyContextConfiguration;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        DataApiCoreContextConfiguration.class,
        DataApiCoreAdminContextConfiguration.class,
        ActionsContextConfiguration.class,
        ProxyConfiguration.class,
        A3JettyContextConfiguration.class
})
public class DataApiContextConfiguration {
    @Bean
    public A3JettyConfiguration a3JettyServletsConfiguration() {
        return new A3JettyConfiguration(Tuple2List.fromPairs(
                "/api/*", ru.yandex.chemodan.util.web.NS.API,
                "/v1/data/*", ru.yandex.chemodan.util.web.NS.API,
                "/internal/*", NS.INTERNAL,
                "/profile/*", NS.PROFILE,
                "/*", NS.ROOT
        ));
    }

    @Bean
    public ProxyPingLockWorkerService proxyPingLockWorkerService(
            AliveAppInfoHolder aliveAppInfoHolder,
            CoolPingServlet lockChecker,
            @Value("${alive-apps.initial-state}") String lockState) {
        return new ProxyPingLockWorkerService(aliveAppInfoHolder, lockChecker, lockState);
    }
}
