package ru.yandex.chemodan.app.dataapi;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.apps.profile.ProfileContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.datasources.passport.PassportDataSourceContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.datasources.yamoney.YamoneyContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.datasources.ydb.YdbDataSourceContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.generic.GenericObjectsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.generic.loader.DataRecordsLoaderContextConfiguration;
import ru.yandex.chemodan.app.dataapi.core.logbroker.LogBrokerHandlerContextConfiguration;
import ru.yandex.chemodan.app.dataapi.maintenance.MapPointsHistoryCleaner;
import ru.yandex.chemodan.util.ping.PingerChecker;
import ru.yandex.chemodan.util.tvm.TvmClientInfo;
import ru.yandex.chemodan.util.tvm.TvmClientInfoRegistry;
import ru.yandex.chemodan.zk.registries.tvm.ZkTvmContextConfiguration;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        DataApiBaseContextConfiguration.class,
        DataRecordsLoaderContextConfiguration.class,
        GenericObjectsContextConfiguration.class,
        LogBrokerHandlerContextConfiguration.class,
        PassportDataSourceContextConfiguration.class,
        YdbDataSourceContextConfiguration.class,
        ProfileContextConfiguration.class,
        ZkTvmContextConfiguration.class,
        YamoneyContextConfiguration.class,
        Tvm2BaseContextConfiguration.class
})
public class DataApiCoreContextConfiguration {

    @Bean
    public PingerChecker tvmRegistryChecker(Tvm2 tvm, TvmClientInfoRegistry registry) {
        tvm.setSrcClientIds(() -> registry.getAll().map(TvmClientInfo::getTvmClientId).unique());
        tvm.setNoUserTicketsCheckSrcClientIds(i -> registry.getO(i).isMatch(TvmClientInfo::isAllowSetAnyUid));
        return registry::isInitialized;
    }

    @Bean
    public MapPointsHistoryCleaner mapPointsHistoryCleaner() {
        MapPointsHistoryCleaner cleaner = new MapPointsHistoryCleaner();
        cleaner.setSleepMode("period");
        cleaner.setSleepBeforeFirstRun(false);
        return cleaner;
    }
}
