package ru.yandex.chemodan.app.dataapi;

import org.springframework.context.ConfigurableApplicationContext;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.log.DataapiLog4jHelper;
import ru.yandex.chemodan.bazinga.ChemodanBazingaClientContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanCommonContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanMainSupport;
import ru.yandex.chemodan.log.Log4jHelper;
import ru.yandex.commune.a3.action.ActionDispatcher;
import ru.yandex.commune.a3.action.http.ActionInvocationServlet;
import ru.yandex.misc.db.monica.JdbcMetricsSwitch;
import ru.yandex.misc.log.mlf.Level;
import ru.yandex.misc.spring.jdbc.JdbcTemplateHacks;
import ru.yandex.misc.version.AppName;
import ru.yandex.misc.version.SimpleAppName;

/**
 * @author tolmalev
 */
public class DataApiMain extends ChemodanMainSupport {

    public static void main(String[] args) {
        JdbcMetricsSwitch.ENABLED = true;
        new DataApiMain().runMain(args);
    }

    @Override
    public AppName applicationName() {
        return new SimpleAppName("dataapi", "dataapi");
    }

    @Override
    public ListF<Class<?>> applicationSpecificContextPath() {
        return Cf.list(
                ChemodanCommonContextConfiguration.class,
                ChemodanBazingaClientContextConfiguration.class,
                DataApiContextConfiguration.class);
    }

    @Override
    protected void postProcessApplicationContextBeforeRefresh(ConfigurableApplicationContext context) {
        super.postProcessApplicationContextBeforeRefresh(context);

        context.getEnvironment().addActiveProfile("dataapi");
    }

    @Override
    protected void configureLogger() {

        Log4jHelper.rootLoggerBuilder().appName(applicationName()).bufferSize(2 * 1024 * 1024).build();

        Log4jHelper.accessLoggerBuilder().bufferSize(2 * 1024 * 1024).appName(applicationName()).build();

        DataapiLog4jHelper.configureDatabaseChangesTskvLogger(applicationName());

        DataapiLog4jHelper.configureLogger(JdbcTemplateHacks.class, Level.ERROR);
        DataapiLog4jHelper.configureLogger(ActionDispatcher.class, Level.ERROR);
        DataapiLog4jHelper.configureLogger(ActionInvocationServlet.class, Level.WARN);
    }
}
