package ru.yandex.chemodan.app.dataapi;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.inside.yt.kosher.Yt;
import ru.yandex.inside.yt.kosher.impl.YtUtils;

/**
 * @author yashunsky
 */

@Configuration
public class DataApiYtContextConfiguration {
    @Value("${dataapi.yt.http.proxy}")
    private String ytHttpProxyUrl;

    @Value("${dataapi.datasync-yt.user.yt.token}")
    private String ytUserOauthToken;

    @Bean
    public Yt dataApiYtClient() {
        return YtUtils.http(ytHttpProxyUrl, ytUserOauthToken);
    }
}
