package ru.yandex.chemodan.app.dataapi.api;

import java.util.regex.Pattern;

import ru.yandex.chemodan.app.dataapi.api.data.record.RecordId;
import ru.yandex.chemodan.app.dataapi.utils.InvalidIdException;

/**
 * @author tolmalev
 */
public class DataNamesUtils {

    // dot isn't first
    // letters, digits, dot, hypen and underscore allowed
    public static final Pattern idPattern = Pattern.compile("^[\\w\\d_\\-=][\\w\\d_\\-=\\.@]{0,127}$");

    public static boolean isValidId(String id) {
        return idPattern.matcher(id).matches();
    }

    public static void validateId(String id) {
        if (!isValidId(id)) {
            throw new InvalidIdException("Invalid id " + id);
        }
    }

    public static void validateId(RecordId recordId) {
        validateId(recordId.collectionId());
        validateId(recordId.recordId());
    }
}
