package ru.yandex.chemodan.app.dataapi.api;

import org.junit.Test;

import ru.yandex.chemodan.app.dataapi.utils.InvalidIdException;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DataNamesUtilsTest {

    @Test
    public void ids() {
        Assert.isTrue(DataNamesUtils.isValidId("sadasd"));
        Assert.isTrue(DataNamesUtils.isValidId("sadasdASD"));
        Assert.isTrue(DataNamesUtils.isValidId("sadasdASD_-."));
        Assert.isTrue(DataNamesUtils.isValidId("home=work="));
        // For ya-tickets orders
        Assert.isTrue(DataNamesUtils.isValidId("1428496241650@8c80da8c-89cd-404f-9cdd-bb3790110ac1"));

        Assert.isFalse(DataNamesUtils.isValidId(""));
        Assert.isFalse(DataNamesUtils.isValidId("."));
        Assert.isFalse(DataNamesUtils.isValidId(".asdasd"));
        Assert.isFalse(DataNamesUtils.isValidId(
                "1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890"));
    }

    @Test(expected = InvalidIdException.class)
    public void invalidException() {
        DataNamesUtils.validateId(".asdasd");
    }

    @Test(expected = InvalidIdException.class)
    public void invalidUtfException() {
        DataNamesUtils.validateId("\u0000");
    }
}
