package ru.yandex.chemodan.app.dataapi.api;

import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;

/**
 * @author tolmalev
 */
public abstract class OneCollectionChangesAsyncHandlerSupport implements DatabaseChangedEventAsyncHandler {
    private final CollectionRef colRef;

    protected OneCollectionChangesAsyncHandlerSupport(CollectionRef colRef) {
        this.colRef = colRef;
    }

    @Override
    public void databaseChanged(DatabaseChange databaseChange) {
        if (!colRef.refersDbMatching(databaseChange.patchedDatabase())) {
            return;
        }

        collectionChanged(databaseChange.filterByCollection(colRef));
    }

    protected abstract void collectionChanged(DatabaseChange change);
}
