package ru.yandex.chemodan.app.dataapi.api.context;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseAppContext extends DatabaseContext {
    private final String appName;

    public DatabaseAppContext(String appName) {
        this.appName = appName;
    }

    @Override
    public Option<DatabaseAppContext> appContextO() {
        return Option.of(this);
    }

    public String appName() {
        return appName;
    }

    @Override
    public String dbAppId() {
        return appName;
    }

    public AppDatabaseRef consDbRef(String databaseId) {
        return new AppDatabaseRef(this, databaseId);
    }
}
