package ru.yandex.chemodan.app.dataapi.api.context;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilter;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilterSource;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.GlobalDatabaseRef;
import ru.yandex.misc.db.q.ConditionUtils;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class DatabaseContext extends DefaultObject implements DatabaseContextSource, DatabasesFilterSource {
    private static final String GLOBAL_APP_ID = ".@$GLOBAL";

    private static final DatabaseContext GLOBAL = new DatabaseContext() {
        @Override
        public Option<DatabaseAppContext> appContextO() {
            return Option.empty();
        }

        @Override
        public String dbAppId() {
            return GLOBAL_APP_ID;
        }

        @Override
        public DatabaseRef consDbRef(String databaseId) {
            return new GlobalDatabaseRef(databaseId);
        }
    };

    public static DatabaseContext cons(Option<String> appName) {
        return appName.map((Function<String, DatabaseContext>) DatabaseAppContext::new)
                .getOrElse(DatabaseContext::global);
    }

    public static DatabaseContext fromDbAppId(Option<String> appIdO) {
        return appIdO.isMatch(DatabaseContext::isAppContextName)
                ? new DatabaseAppContext(appIdO.get())
                : global();
    }

    private static boolean isAppContextName(String appId) {
        return !GLOBAL_APP_ID.equals(appId);
    }

    public static DatabaseContext global() {
        return GLOBAL;
    }

    @Override
    public abstract Option<DatabaseAppContext> appContextO();

    @Override
    public abstract String dbAppId();

    public abstract DatabaseRef consDbRef(String databaseId);

    @Override
    public DatabaseContext dbContext() {
        return this;
    }

    @Override
    public Option<String> appNameO() {
        return appContextO()
                .map(DatabaseAppContext::appName);
    }

    @Override
    public boolean hasGlobalContext() {
        return !hasAppContext();
    }

    @Override
    public boolean hasAppContext() {
        return appContextO().isPresent();
    }

    @Override
    public String toString() {
        return appNameO().getOrElse("<GLOBAL>");
    }

    @Override
    public DatabasesFilter toDbsFilter() {
        return new DatabasesFilter(this);
    }

    public SqlCondition toSqlCondition() {
        return ConditionUtils.column("app").eq(dbAppId());
    }
}
