package ru.yandex.chemodan.app.dataapi.api.context;

import ru.yandex.bolts.collection.Option;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface DatabaseContextSource {
    DatabaseContext dbContext();

    default Option<DatabaseAppContext> appContextO() {
        return dbContext().appContextO();
    }

    default Option<String> appNameO() {
        return dbContext().appNameO();
    }

    default String dbAppId() {
        return dbContext().dbAppId();
    }

    default boolean isBoundTo(DatabaseContextSource otherCtxSrc) {
        return dbContext().equals(otherCtxSrc.dbContext());
    }

    default boolean hasGlobalContext() {
        return dbContext().hasGlobalContext();
    }

    default boolean hasAppContext() {
        return dbContext().hasAppContext();
    }
}
