package ru.yandex.chemodan.app.dataapi.api.data.field;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.test.Assert;

/**
 * @author tolmalev
 */
public class DataFieldTest {
    @Test
    public void create() {
        DataField.infinity();
        DataField.nan();
        DataField.negativeInfinity();
        DataField.nul();

        DataField.bool(true);
        DataField.bool(false);

        DataField.integer(123);
        DataField.decimal(123);

        DataField.string("1212312");
        DataField.string("");

        DataField.bytes(new byte[]{});
        DataField.bytes(new byte[]{1, 2, 3, 4});
    }

    @Test
    public void size() {
        Assert.equals(DataSize.fromBytes(8), DataField.infinity().getSize());
        Assert.equals(DataSize.fromBytes(8), DataField.negativeInfinity().getSize());
        Assert.equals(DataSize.fromBytes(8), DataField.nan().getSize());

        Assert.equals(DataSize.fromBytes(0), DataField.nul().getSize());

        Assert.equals(DataSize.fromBytes(8), DataField.integer(1).getSize());
        Assert.equals(DataSize.fromBytes(8), DataField.decimal(1).getSize());

        Assert.equals(DataSize.fromBytes(1), DataField.bool(true).getSize());
        Assert.equals(DataSize.fromBytes(1), DataField.bool(false).getSize());

        Assert.equals(DataSize.fromBytes(5), DataField.string("12345").getSize());
        Assert.equals(DataSize.fromBytes(0), DataField.string("").getSize());

        Assert.equals(DataSize.fromBytes(3), DataField.bytes(new byte[]{1, 2, 3}).getSize());

        MapF<String, DataField> map = Cf.hashMap();
        map.put("A", DataField.bytes(new byte[] {1}));
        map.put("B", DataField.bytes(new byte[] {2}));
        Assert.equals(DataSize.fromBytes(4), DataField.map(map).getSize());

    }
}
