package ru.yandex.chemodan.app.dataapi.api.data.field;

import org.joda.time.DateTime;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.web.direct.DirectDataFieldMapper;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.misc.enums.EnumResolver;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author tolmalev
 */
public enum DataFieldType {
    @ProtoField(n = 1)
    DECIMAL(Double.class, 8, DirectDataFieldMapper.DECIMAL),
    @ProtoField(n = 2)
    INTEGER(Long.class, 8, DirectDataFieldMapper.INTEGER),
    @ProtoField(n = 3)
    BOOLEAN(Boolean.class, 1, DirectDataFieldMapper.BOOLEAN),
    @ProtoField(n = 4)
    STRING(String.class, DirectDataFieldMapper.STRING),
    @ProtoField(n = 5)
    BYTES(byte[].class, DirectDataFieldMapper.BYTES),
    @ProtoField(n = 6)
    NULL(Void.class, 0, DirectDataFieldMapper.NULL),
    @ProtoField(n = 7)
    INFINITY(Double.class, 8, DirectDataFieldMapper.INFINITY),
    @ProtoField(n = 8)
    NEGATIVE_INFINITY(Double.class, 8, DirectDataFieldMapper.NEGATIVE_INFINITY),
    @ProtoField(n = 9)
    NAN(Double.class, 8, DirectDataFieldMapper.NAN),
    @ProtoField(n = 10)
    TIMESTAMP(Instant.class, 8, DirectDataFieldMapper.TIMESTAMP),
    @ProtoField(n = 11)
    LIST(ListF.class, DirectDataFieldMapper.LIST),
    @ProtoField(n = 12)
    MAP(MapF.class, DirectDataFieldMapper.MAP),
    @ProtoField(n = 13)
    DATETIME(DateTime.class, 12, DirectDataFieldMapper.DATETIME)
    ;

    private static final MapF<String, DataFieldType> directNameToType = consDirectNameToTypeMap();

    private static MapF<String, DataFieldType> consDirectNameToTypeMap() {
        return Cf.x(values())
                .reverse()
                .toMapMappingToKey(DataFieldType::directName);
    }

    public static DataFieldType byDirectName(String directName) {
        return directNameToType.getO(directName)
                .getOrThrow(() -> new IllegalArgumentException("Unknown direct type name = " + directName));
    }

    public final ClassX valueClass;
    public final Option<Integer> fixedSizeBytes;
    public final DirectDataFieldMapper directMapper;

    public static final EnumResolver<DataFieldType> R = EnumResolver.er(DataFieldType.class);

    DataFieldType(Class valueClass, DirectDataFieldMapper directMapper) {
        this(valueClass, Option.empty(), directMapper);
    }

    DataFieldType(Class valueClass, int fixedSizeBytes, DirectDataFieldMapper directMapper) {
        this(valueClass, Option.of(fixedSizeBytes), directMapper);
    }

    DataFieldType(Class valueClass, Option<Integer> fixedSizeBytes, DirectDataFieldMapper directMapper) {
        this.valueClass = ClassX.wrap(valueClass);
        this.fixedSizeBytes = fixedSizeBytes;
        this.directMapper = directMapper;
    }

    private String directName() {
        return directMapper.typeName;
    }
}
