package ru.yandex.chemodan.app.dataapi.api.data.field;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.dataSize.DataSize;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
@Bendable
public class DataFields extends DefaultObject {
    public final static DataFields EMPTY = new DataFields(Cf.map());

    public static final DataSize EMPTY_RECORD_SIZE = DataSize.fromBytes(128);

    @BenderPart
    public final MapF<String, DataField> data;

    public DataFields(NamedDataField... fields) {
        this(Cf.list(fields));
    }

    public DataFields(CollectionF<NamedDataField> fields) {
        this(fields.toMap(NamedDataField::asTuple2));
    }

    public DataFields(MapF<String, DataField> data) {
        this.data = data;
    }

    public static DataFields fromFieldsSource(CollectionF<? extends NamedDataFieldSource> fields) {
        return new DataFields(fields.map(NamedDataFieldSource::toNamedDataField));
    }

    public DataSize getRecordSize() {
        DataSize keysSize = data
                .values()
                .map(DataField::getSize)
                .foldLeft(DataSize.ZERO, DataSize::plus);

        DataSize fieldsSize = data
                .keys()
                .map(s -> DataSize.fromBytes(s.getBytes().length))
                .foldLeft(DataSize.ZERO, DataSize::plus);

        return keysSize.plus(fieldsSize).plus(EMPTY_RECORD_SIZE);
    }

    public DataFields plusO(Option<NamedDataField> fieldO) {
        return fieldO.map(this::plus)
                .getOrElse(this);
    }

    public DataFields plus(NamedDataField field) {
        return new DataFields(data.plus1(field.name, field.value));
    }

    public DataFields plus(String name, DataField field) {
        return new DataFields(data.plus1(name, field));
    }

    public DataFields without(String name) {
        MapF<String, DataField> data = Cf.toHashMap(this.data);
        data.removeTs(name);
        return new DataFields(data.unmodifiable());
    }

    public MapF<String, DataField> data() {
        return data;
    }

    public ListF<ProtobufDataField> toProtobufFields() {
        return data.mapEntries(ProtobufDataField::new);
    }

    public ListF<NamedDataField> toNamedDataFields() {
        return data.mapEntries(NamedDataField::new);
    }

    public DataField get(String name) {
        return data.getTs(name);
    }

    public Option<DataField> getO(String name) {
        return data.getO(name);
    }

    public ListF<FieldChange> toPutFieldChanges() {
        return data.mapValuesWithKey(FieldChange::put)
                .values()
                .toList();
    }
}
