package ru.yandex.chemodan.app.dataapi.api.data.field;

import ru.yandex.chemodan.util.bender.JsonFieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.MarshallerContext;
import ru.yandex.misc.bender.serialize.ToFieldMarshallerSupport;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DataFieldsMarshallerUnmarshaller extends ToFieldMarshallerSupport
        implements JsonFieldLevelUnmarshaller
{
    private static final DataFieldMarshallerUnmarshaller fieldMarshallerUnmarshaller =
            new DataFieldMarshallerUnmarshaller();

    @Override
    public void writeJsonToField(BenderJsonWriter writer, Object obj, MarshallerContext context) {
        DataFields fields = (DataFields) obj;
        writer.writeObjectStart();
        for(NamedDataField field : fields.toNamedDataFields()) {
            writer.writeFieldName(field.name);
            fieldMarshallerUnmarshaller.writeJsonToField(writer, field.value, context);
        }
        writer.writeObjectEnd();
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode node, UnmarshallerContext context) {
        ModifiableDataFields dataFields = new ModifiableDataFields();
        for(String fieldName : node.getFieldNames()) {
            DataField dataField = fieldMarshallerUnmarshaller.parseDataField(node.getField(fieldName).get());
            dataFields.add(fieldName, dataField);
        }
        return ParseResult.result(dataFields.unmodifiable());
    }
}
