package ru.yandex.chemodan.app.dataapi.api.data.field;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class ModifiableDataFields extends DefaultObject {
    final MapF<String, DataField> data;

    public ModifiableDataFields() {
        this(Cf.hashMap());
    }

    public ModifiableDataFields(DataFields dataFields) {
        this(Cf.toHashMap(dataFields.data));
    }

    private ModifiableDataFields(MapF<String, DataField> data) {
        this.data = data;
    }

    public ModifiableDataFields add(String name, DataField value) {
        data.put(name, value);
        return this;
    }

    public DataFields unmodifiable() {
        return new DataFields(data.unmodifiable());
    }
}
