package ru.yandex.chemodan.app.dataapi.api.data.field;

import org.joda.time.DateTime;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.lang.DefaultObject;

/**
 * TODO: rename to DataField
 * @author Dmitriy Amelin (lemeh)
 * @see DataField
 */
@Bendable
public class NamedDataField extends DefaultObject {
    @BenderPart(strictName = true, name = "field_id")
    public final String name;
    @BenderPart
    public final DataField value;

    public NamedDataField(String name, DataField value) {
        this.name = name;
        this.value = value;
    }

    public static NamedDataField nan(String name) {
        return new NamedDataField(name, DataField.nan());
    }

    public static NamedDataField infinity(String name) {
        return new NamedDataField(name, DataField.infinity());
    }

    public static NamedDataField negativeInfinity(String name) {
        return new NamedDataField(name, DataField.negativeInfinity());
    }

    public static NamedDataField bool(String name, boolean value) {
        return new NamedDataField(name, DataField.bool(value));
    }

    public static NamedDataField integer(String name, long value) {
        return new NamedDataField(name, DataField.integer(value));
    }

    public static NamedDataField decimal(String name, double value) {
        return new NamedDataField(name, DataField.decimal(value));
    }

    public static NamedDataField string(String name, String value) {
        return new NamedDataField(name, DataField.string(value));
    }

    public static NamedDataField bytes(String name, byte[] value) {
        return new NamedDataField(name, DataField.bytes(value));
    }

    public static NamedDataField nul(String name) {
        return new NamedDataField(name, DataField.nul());
    }

    public static NamedDataField timestamp(String name, Instant timestamp) {
        return new NamedDataField(name, DataField.timestamp(timestamp));
    }

    public static NamedDataField dateTime(String name, DateTime dateTime) {
        return new NamedDataField(name, DataField.dateTime(dateTime));
    }

    public static NamedDataField list(String name, DataField... values) {
        return new NamedDataField(name, DataField.list(values));
    }

    public static NamedDataField list(String name, ListF<DataField> values) {
        return new NamedDataField(name, DataField.list(values));
    }

    public static NamedDataField map(String name, MapF<String, DataField> map) {
        return new NamedDataField(name, DataField.map(map));
    }

    public static NamedDataField map(String name, NamedDataField... fields) {
        return map(name, toDataFieldMap(fields));
    }

    public Tuple2<String, DataField> asTuple2() {
        return Tuple2.tuple(name, value);
    }

    public static MapF<String, DataField> toDataFieldMap(NamedDataField... fields) {
        return toDataFieldMap(Cf.list(fields));
    }

    public static MapF<String, DataField> toDataFieldMap(ListF<NamedDataField> fields) {
        return fields.toMap(NamedDataField::asTuple2);
    }
}
