package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;

/**
 * @author Dmitriy Amelin (lemeh)
 */
abstract class AbstractStringIdCondition extends ObjectFilterDelegate<String> {
    public final Option<SetF<String>> idsO;

    AbstractStringIdCondition(ObjectFilter<String> filter) {
        this(filter, Option.<CollectionF<String>>empty());
    }

    AbstractStringIdCondition(ObjectFilter<String> filter, CollectionF<String> ids) {
        this(filter, Option.of(ids));
    }

    private AbstractStringIdCondition(ObjectFilter<String> filter, Option<CollectionF<String>> idsO) {
        super(filter);
        this.idsO = idsO.map(CollectionF::unique);
    }

    public boolean isAllOrWithIds() {
        return isAll() || isWithIds();
    }

    public boolean isWithIds() {
        return idsO.isPresent();
    }
}
