package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;

/**
 * @author dbrylev
 * @author Dmitriy Amelin (lemeh)
 */
public class CollectionIdCondition extends AbstractStringIdCondition {
    private static final ObjectFilter.Field<String> column = ObjectFilter.field("collection_id");

    private CollectionIdCondition(ObjectFilter<String> filter) {
        super(filter);
    }

    private CollectionIdCondition(ObjectFilter<String> filter, CollectionF<String> ids) {
        super(filter, ids);
    }

    public static CollectionIdCondition all() {
        return new CollectionIdCondition(column.all());
    }

    public static CollectionIdCondition eq(String id) {
        return new CollectionIdCondition(column.eq(id), Cf.list(id));
    }

    public static CollectionIdCondition inSet(CollectionF<String> ids) {
        return new CollectionIdCondition(column.inSet(ids), ids);
    }

    public static CollectionIdCondition notInSet(CollectionF<String> ids) {
        return new CollectionIdCondition(column.inSet(ids).not());
    }

    public static CollectionIdCondition like(String pattern) {
        return new CollectionIdCondition(column.like(pattern));
    }
}
