package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.CollectionF;

/**
 * @author dbrylev
 */
abstract class ConditionBuildingExpression<V, R, C> implements ConditionExpression<V, C> {

    protected final ConditionExpression<V, R> expression;

    public ConditionBuildingExpression(ConditionExpression<V, R> expression) {
        this.expression = expression;
    }

    protected abstract C build(R result);

    @Override
    public C eq(V value) {
        return build(expression.eq(value));
    }

    @Override
    public C ne(V value) {
        return build(expression.ne(value));
    }

    @Override
    public C gt(V value) {
        return build(expression.gt(value));
    }

    @Override
    public C ge(V value) {
        return build(expression.ge(value));
    }

    @Override
    public C lt(V value) {
        return build(expression.lt(value));
    }

    @Override
    public C le(V value) {
        return build(expression.le(value));
    }

    @Override
    public C inSet(CollectionF<? extends V> values) {
        return build(expression.inSet(values));
    }

    @Override
    public C between(V min, V max) {
        return build(expression.between(min, max));
    }

    @Override
    public C like(String pattern) {
        return build(expression.like(pattern));
    }

    @Override
    public C isNull() {
        return build(expression.isNull());
    }

    @Override
    public C isNotNull() {
        return build(expression.isNotNull());
    }
}
