package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.CollectionF;

/**
 * @author dbrylev
 */
abstract class ConditionConvertingExpression<F, T, R> implements ConditionExpression<F, R> {

    protected final ConditionExpression<T, R> expression;

    public ConditionConvertingExpression(ConditionExpression<T, R> expression) {
        this.expression = expression;
    }

    protected abstract T convert(F value);

    @Override
    public R eq(F value) {
        return expression.eq(convert(value));
    }

    @Override
    public R ne(F value) {
        return expression.ne(convert(value));
    }

    @Override
    public R gt(F value) {
        return expression.gt(convert(value));
    }

    @Override
    public R ge(F value) {
        return expression.ge(convert(value));
    }

    @Override
    public R lt(F value) {
        return expression.lt(convert(value));
    }

    @Override
    public R le(F value) {
        return expression.le(convert(value));
    }

    @Override
    public R inSet(CollectionF<? extends F> values) {
        return expression.inSet(values.map(this::convert));
    }

    @Override
    public R between(F min, F max) {
        return expression.between(convert(min), convert(max));
    }

    @Override
    public R like(String pattern) {
        return expression.like(pattern);
    }

    @Override
    public R isNull() {
        return expression.isNull();
    }

    @Override
    public R isNotNull() {
        return expression.isNotNull();
    }
}
