package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.chemodan.util.postgres.PgSqlQueryUtils;

/**
 * @author dbrylev
 */
public interface ConditionExpression<T, R> {

    R eq(T value);

    R ne(T value);

    R gt(T value);

    R ge(T value);

    R lt(T value);

    R le(T value);

    R inSet(CollectionF<? extends T> values);

    R between(T min, T max);

    R like(String pattern);

    default R startsWith(String prefix) {
        return like(PgSqlQueryUtils.escapeForLike(prefix) + "%");
    }

    R isNull();

    R isNotNull();
}
