package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.ByDataRecordOrder;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.OrderingExpression;

/**
 * @author dbrylev
 */
abstract class ConvertingColumnBase<F, C extends RecordCondition>
        extends ConditionConvertingExpression<F, Object, C> implements OrderingExpression
{
    private final RecordColumn<Object, C> column;
    private final Function<F, ?> converter;

    @SuppressWarnings("unchecked")
    public <T> ConvertingColumnBase(RecordColumn<T, ? extends C> column, Function<F, T> converter) {
        super((ConditionExpression<Object, C>) column);
        this.column = (RecordColumn<Object, C>) column;
        this.converter = converter;
    }

    @Override
    protected Object convert(F value) {
        return converter.apply(value);
    }

    @Override
    public ByDataRecordOrder orderBy(boolean asc) {
        return column.orderBy(asc);
    }
}
