package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.CollectionF;

/**
 * @author dbrylev
 */
public class DataCondition extends RecordCondition {

    protected DataCondition(Matcher matcher) {
        super(matcher);
    }

    public static DataCondition all() {
        return new DataCondition(Matcher.constant(true));
    }

    public static DataCondition none() {
        return new DataCondition(Matcher.constant(false));
    }

    public DataCondition and(DataCondition other) {
        return new DataCondition(getMatcher().and(other.getMatcher()));
    }

    public DataCondition and(CollectionF<DataCondition> other) {
        return other.iterator().foldLeft(this, DataCondition::and);
    }

    public DataCondition or(DataCondition other) {
        return new DataCondition(getMatcher().and(other.getMatcher()));
    }

    public DataCondition or(CollectionF<DataCondition> other) {
        return other.iterator().foldLeft(this, DataCondition::or);
    }

    public DataCondition not() {
        return new DataCondition(getMatcher().not());
    }
}
