package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.collection.SetF;

/**
 * @author dbrylev
 */
public class DataFieldsCapture implements ConditionAware<DataFieldsCapture> {

    private final SetF<String> fields;

    private DataFieldsCapture(SetF<String> fields) {
        this.fields = fields;
    }

    public static DataFieldsCapture empty() {
        return of(Cf.set());
    }

    public static DataFieldsCapture of(String field) {
        return of(Cf.set(field));
    }

    public static DataFieldsCapture of(CollectionF<String> fields) {
        return new DataFieldsCapture(fields.unique());
    }

    @Override
    public DataFieldsCapture and(DataFieldsCapture other) {
        return new DataFieldsCapture(fields.plus(other.fields));
    }

    @Override
    public DataFieldsCapture or(DataFieldsCapture other) {
        return new DataFieldsCapture(fields.plus(other.fields));
    }

    @Override
    public DataFieldsCapture not() {
        return this;
    }

    public SetF<String> getFields() {
        return fields;
    }
}
