package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.misc.db.q.ConditionUtils;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class DatabaseCondition extends SqlConditionBased {

    private DatabaseCondition(SqlCondition condition) {
        super(condition);
    }

    public static TypedColumn<Integer> recordsCount() {
        return new TypedColumn<>("records_count");
    }

    public static DatabaseCondition all() {
        return new DatabaseCondition(SqlCondition.trueCondition());
    }

    public static class TypedColumn<T> {
        private final ConditionUtils.Column expression;

        private TypedColumn(String columnName) {
            this.expression = ConditionUtils.column(columnName);
        }

        private DatabaseCondition op(String op, T value) {
            return new DatabaseCondition(expression.op(op, value));
        }

        public DatabaseCondition gt(T value) {
            return op(">", value);
        }
    }
}
