package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1B;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author Dmitriy Amelin (lemeh)
 */
abstract class ObjectFilterDelegate<T extends Comparable<T>> {
    private final ObjectFilter<T> filter;

    ObjectFilterDelegate(ObjectFilter<T> filter) {
        this.filter = filter;
    }

    public boolean isAll() {
        return filter.isAll();
    }

    public <O> ListF<O> filter(ListF<O> objects, Function<O, T> mapperF) {
        return filter.filter(objects, mapperF);
    }

    public <O> Function1B<O> getFilterF(Function<O, T> mapperF) {
        return obj -> matches(mapperF.apply(obj));
    }

    public boolean matches(T value) {
        return filter.matches(value);
    }

    public SqlCondition getCondition() {
        return filter.getCondition();
    }
}
