package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.ByDataRecordOrder;
import ru.yandex.chemodan.app.dataapi.api.data.filter.ordering.OrderingExpression;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
abstract class RecordColumn<T, C extends RecordCondition>
        extends ConditionBuildingExpression<T, ObjectFilter<?>, C> implements OrderingExpression
{
    protected final ObjectFilter.ConvertingField<T, ?> field;
    protected final Function<DataRecord, Option<T>> extractor;

    @SuppressWarnings("unchecked")
    protected RecordColumn(
            ObjectFilter.ConvertingField<T, ?> field,
            Function<DataRecord, Option<T>> extractor)
    {
        super((ConditionExpression) field);
        this.field = field;
        this.extractor = extractor;
    }

    @Override
    public C like(String pattern) {
        return build(stringField().like(pattern));
    }

    @Override
    public C isNull() {
        return condition(field.getColumn().isNull(), r -> Option.of(!extractor.apply(r).isPresent()));
    }

    @Override
    public C isNotNull() {
        return condition(field.getColumn().isNotNull(), r -> Option.of(extractor.apply(r).isPresent()));
    }

    @Override
    protected C build(ObjectFilter<?> filter) {
        return condition(filter.getCondition(), r -> extractor.apply(r).map(v -> field.matches(filter, v)));
    }

    @Override
    public ByDataRecordOrder orderBy(boolean asc) {
        return new ByDataRecordOrder(Cf.list(field.orderComponent(extractor, asc)));
    }

    protected abstract C condition(SqlCondition condition, Function<DataRecord, Option<Boolean>> matcher);

    protected abstract ObjectFilter.ConvertingField<String, ?> stringField();
}
