package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.misc.db.q.SqlCondition;

/**
 * @author dbrylev
 */
public class RecordIdColumn extends RecordColumn<String, RecordCondition> {

    public static final RecordIdColumn C = new RecordIdColumn();

    private RecordIdColumn() {
        super(new ObjectFilter.ConvertingField<>("record_id", t -> t), r -> Option.of(r.getRecordId()));
    }

    @Override
    protected RecordCondition condition(SqlCondition condition, Function<DataRecord, Option<Boolean>> matcher) {
        return new RecordCondition(new RecordCondition.Matcher(
                condition, new RecordPredicate(matcher), DataFieldsCapture.empty()));
    }

    @Override
    protected ObjectFilter.ConvertingField<String, ?> stringField() {
        return field;
    }
}
