package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;

/**
 * @author dbrylev
 * @author Dmitriy Amelin (lemeh)
 */
public class RecordIdCondition extends AbstractStringIdCondition {
    private static final ObjectFilter.Field<String> column = ObjectFilter.field("record_id");

    private RecordIdCondition(ObjectFilter<String> filter) {
        super(filter);
    }

    private RecordIdCondition(ObjectFilter<String> filter, CollectionF<String> ids) {
        super(filter, ids);
    }

    public static RecordIdCondition all() {
        return new RecordIdCondition(column.all());
    }

    public static RecordIdCondition eq(String id) {
        return new RecordIdCondition(column.eq(id), Cf.set(id));
    }

    public static RecordIdCondition ne(String id) {
        return new RecordIdCondition(column.eq(id).not());
    }

    public static RecordIdCondition gt(String from) {
        return new RecordIdCondition(column.gt(from));
    }

    public static RecordIdCondition lt(String from) {
        return new RecordIdCondition(column.lt(from));
    }

    public static RecordIdCondition between(String min, String max) {
        return new RecordIdCondition(column.between(min, max));
    }

    public static RecordIdCondition inSet(CollectionF<String> values) {
        return new RecordIdCondition(column.inSet(values), values);
    }
}
