package ru.yandex.chemodan.app.dataapi.api.data.filter.condition;

import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;

/**
 * @author dbrylev
 */
public class RecordPredicate implements ConditionAware<RecordPredicate> {

    private final Function<DataRecord, Option<Boolean>> matcher;

    public RecordPredicate(Function<DataRecord, Option<Boolean>> matcher) {
        this.matcher = matcher;
    }

    @Override
    public RecordPredicate and(RecordPredicate other) {
        return new RecordPredicate(rec -> {
            Option<Boolean> left = matcher.apply(rec);
            Option<Boolean> right = other.matcher.apply(rec);

            return left.isPresent() && right.isPresent() ? Option.of(left.isSome(true) && right.isSome(true))
                    : left.isSome(false) || right.isSome(false) ? Option.of(false)
                    : Option.empty();
        });
    }

    @Override
    public RecordPredicate or(RecordPredicate other) {
        return new RecordPredicate(rec -> {
            Option<Boolean> left = matcher.apply(rec);
            Option<Boolean> right = other.matcher.apply(rec);

            return left.isPresent() && right.isPresent() ? Option.of(left.isSome(true) || right.isSome(true))
                    : left.isSome(true) || right.isSome(true) ? Option.of(true)
                    : Option.empty();
        });
    }

    @Override
    public RecordPredicate not() {
        return new RecordPredicate(rec -> matcher.apply(rec).map(r -> !r));
    }

    public boolean matches(DataRecord record) {
        return matcher.apply(record).isSome(true);
    }
}
