package ru.yandex.chemodan.app.dataapi.api.data.filter.ordering;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.misc.db.q.SqlExpression;
import ru.yandex.misc.db.q.SqlOrder;
import ru.yandex.misc.db.q.SqlOrderElement;

/**
 * @author dbrylev
 */
public class ByDataRecordOrder implements RecordOrder {

    private final ListF<Component> components;

    public ByDataRecordOrder(ListF<Component> components) {
        this.components = components;
    }

    public static ByDataRecordOrder unordered() {
        return new ByDataRecordOrder(Cf.list());
    }

    public static ByDataRecordOrder orderBy(OrderingExpression column) {
        return unordered().andThen(column);
    }

    public static ByDataRecordOrder orderByDesc(OrderingExpression column) {
        return unordered().andThenDesc(column);
    }

    public ByDataRecordOrder andThen(OrderingExpression column) {
        return andThen(column.orderBy());
    }

    public ByDataRecordOrder andThenDesc(OrderingExpression column) {
        return andThen(column.orderByDesc());
    }

    public ByDataRecordOrder andThen(ByDataRecordOrder other) {
        return new ByDataRecordOrder(components.plus(other.components));
    }

    @Override
    public Comparator<DataRecord> comparator() {
        return components.isNotEmpty()
                ? components.iterator().map(Component::comparator).reduceLeft(Comparator::thenComparing)
                : Comparator.constEqualComparator();
    }

    @Override
    public SqlOrder toSqlOrder() {
        return components.isNotEmpty()
                ? new SqlOrder(components.map(Component::orderElement))
                : SqlOrder.unordered();
    }

    public static class Component {
        private static final Comparator<Option<?>> noneLastReversedComparator =
                Comparator.naturalComparatorUnchecked().reversed().nullLowC().compose(Option::getOrNull);

        private static final Comparator<Option<?>> noneLastComparator =
                noneLastReversedComparator.reversed();

        private final SqlExpression expression;
        private final Function<DataRecord, Option<?>> extractor;
        private final boolean asc;

        public <T extends Comparable<T>> Component(
                SqlExpression expression, Function<DataRecord, Option<T>> extractor, boolean asc)
        {
            this.expression = expression;
            this.extractor = extractor.uncheckedCast();
            this.asc = asc;
        }

        public Comparator<DataRecord> comparator() {
            return asc ? extractor.andThen(noneLastComparator) : extractor.andThen(noneLastReversedComparator);
        }

        public SqlOrderElement orderElement() {
            return new SqlOrderElement(expression.sql(), asc);
        }
    }
}
