package ru.yandex.chemodan.app.dataapi.api.data.filter.ordering;

import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordId;
import ru.yandex.misc.db.q.SqlOrder;

/**
 * @author osidorkin
 */
public enum ByIdRecordOrder implements RecordOrder {
    COLLECTION_ID_ASC_RECORD_ID_ASC(
            Comparators.ROWS_COMPARATOR,
            SqlOrder.orderByColumn("collection_id").andThen("record_id")),
    COLLECTION_ID_DESC_RECORD_ID_DESC(
            Comparators.ROWS_COMPARATOR.reversed(),
            SqlOrder.orderByColumnDesc("collection_id").andThenDesc("record_id")),
    RECORD_ID_ASC(
            Comparators.RECORD_ID_COMPARATOR,
            SqlOrder.orderByColumn("record_id")),
    RECORD_ID_DESC(
            Comparators.RECORD_ID_COMPARATOR.reversed(),
            SqlOrder.orderByColumnDesc("record_id")),
    // XXX we have wrong collate at apidb and smcdb first shard CHEMODAN-53027
    COLLECTION_ID_ASC_RECORD_ID_ASC_COLLATE_C(
            Comparators.ROWS_COMPARATOR,
            SqlOrder.orderByColumn("collection_id COLLATE \"C\"").andThen("record_id COLLATE \"C\""))
    ;

    private static class Comparators {
        private static final Comparator<RecordId> COLLECTION_ID_COMPARATOR =
                (first, last) -> first.collectionId().compareTo(last.collectionId());

        private static final Comparator<RecordId> RECORD_ID_COMPARATOR =
                (first, last) -> first.recordId().compareTo(last.recordId());

        private static final Comparator<RecordId> ROWS_COMPARATOR =
                COLLECTION_ID_COMPARATOR.thenComparing(RECORD_ID_COMPARATOR);
    }

    private final Comparator<RecordId> comparator;

    private final SqlOrder sqlOrder;

    ByIdRecordOrder(Comparator<RecordId> comparator, SqlOrder sqlOrder) {
        this.comparator = comparator;
        this.sqlOrder = sqlOrder;
    }

    @Override
    public Comparator<DataRecord> comparator() {
        return comparator.compose(DataRecord::id);
    }

    public Comparator<RecordId> recordIdComparator() {
        return comparator;
    }

    @Override
    public SqlOrder toSqlOrder() {
        return sqlOrder;
    }
}
