package ru.yandex.chemodan.app.dataapi.api.data.filter.ordering;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.db.ref.GlobalDatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.misc.test.Assert;

/**
 * @author osidorkin
 */
public class ByIdRecordOrderTest {
    public static final DatabaseHandle TEST_HANDLE = new GlobalDatabaseRef("db").consHandle("handle");

    @Test
    public void isInRightOrder() {
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC.isInRightOrder(Cf.list()));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_DESC_RECORD_ID_DESC.isInRightOrder(Cf.list()));

        ListF<DataRecord> single_list = Cf.list(consTestRecord("1", "1"));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC.isInRightOrder(single_list));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_DESC_RECORD_ID_DESC.isInRightOrder(single_list));

        ListF<DataRecord> double_list = Cf.list(consTestRecord("1", "1"), consTestRecord("1", "1"));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC.isInRightOrder(double_list));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_DESC_RECORD_ID_DESC.isInRightOrder(double_list));

        double_list = Cf.list(consTestRecord("1", "1"), consTestRecord("2", "1"));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC.isInRightOrder(double_list));
        Assert.assertFalse(ByIdRecordOrder.COLLECTION_ID_DESC_RECORD_ID_DESC.isInRightOrder(double_list));

        double_list = Cf.list(consTestRecord("1", "1"), consTestRecord("1", "2"));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC.isInRightOrder(double_list));
        Assert.assertFalse(ByIdRecordOrder.COLLECTION_ID_DESC_RECORD_ID_DESC.isInRightOrder(double_list));

        double_list = Cf.list(consTestRecord("1", "2"), consTestRecord("2", "1"));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC.isInRightOrder(double_list));
        Assert.assertFalse(ByIdRecordOrder.COLLECTION_ID_DESC_RECORD_ID_DESC.isInRightOrder(double_list));

        double_list = Cf.list(consTestRecord("2", "1"), consTestRecord("1", "2"));
        Assert.assertFalse(ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC.isInRightOrder(double_list));
        Assert.assertTrue(ByIdRecordOrder.COLLECTION_ID_DESC_RECORD_ID_DESC.isInRightOrder(double_list));
    }

    @Test
    public void comparator() {
        ListF<DataRecord> list = Cf.list(consTestRecord("1", "2"), consTestRecord("2", "1"));

        Assert.equals(list, list.sorted(ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC.comparator()));
        Assert.equals(list.reverse(), list.sorted(ByIdRecordOrder.COLLECTION_ID_DESC_RECORD_ID_DESC.comparator()));
    }

    private static DataRecord consTestRecord(String collectionId, String recordId) {
        return new DataRecord(
                new DataApiPassportUserId(1L),
                new DataRecordId(TEST_HANDLE, collectionId, recordId),
                1,
                DataFields.EMPTY
        );
    }
}
