package ru.yandex.chemodan.app.dataapi.api.data.filter.ordering;

import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.misc.db.q.SqlOrder;

/**
 * @author dbrylev
 */
public class ByRevisionOrder implements RecordOrder {

    public static final ByRevisionOrder ORDER = new ByRevisionOrder();

    private static final Comparator<DataRecord> comparator = Comparator.wrap(
            java.util.Comparator.comparingLong(DataRecord::getRev));

    private static final SqlOrder order = SqlOrder.orderByColumn("rev");

    @Override
    public Comparator<DataRecord> comparator() {
        return comparator;
    }

    @Override
    public SqlOrder toSqlOrder() {
        return order;
    }
}
