package ru.yandex.chemodan.app.dataapi.api.data.filter.ordering;

import java.util.concurrent.atomic.AtomicLong;

import org.apache.commons.lang3.StringUtils;
import org.joda.time.Instant;

/**
 * @author Maksim Ahramovich
 */
public class OrderedUUID {
    private static final int LEFT_PAD_SIZE = Long.toString(Long.MAX_VALUE).length();
    public static final int ORDERED_UUID_SIZE = 2 * LEFT_PAD_SIZE + 4;

    public static final String MIN_FROM = "0";
    public static final String MAX_TO = StringUtils.leftPad("", ORDERED_UUID_SIZE, '9');

    private static final AtomicLong counter = new AtomicLong(0);
    private static final long appStartTime = System.currentTimeMillis();

    public static String generateOrderedUUID() {
        return generateOrderedUUID(Instant.now());
    }

    public static String generateOrderedUUID(Instant instant) {
        return new StringBuilder(64)
                .append(leftPad(instant.getMillis()))
                .append(leftPad(counter.incrementAndGet() % 1000, 4))
                .append(leftPad(appStartTime)).toString();
    }

    private static String leftPad(long value) {
        return leftPad(value, LEFT_PAD_SIZE);
    }

    private static String leftPad(long value, int size) {
        return StringUtils.leftPad(Long.toString(value), size, '0');
    }
}
