package ru.yandex.chemodan.app.dataapi.api.data.filter.ordering;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.forhuman.Comparator;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.misc.db.q.SqlOrder;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public interface RecordOrder {
    Comparator<DataRecord> comparator();

    SqlOrder toSqlOrder();

    default boolean isInRightOrder(ListF<DataRecord> rows) {
        return rows.size() < 2 || comparator().compare(rows.first(), rows.last()) <= 0;
    }

    default String toSql() {
        return toSqlOrder().toSql();
    }

    static RecordOrder defaultOrder() {
        return ByIdRecordOrder.COLLECTION_ID_ASC_RECORD_ID_ASC;
    }
}
