package ru.yandex.chemodan.app.dataapi.api.data.protobuf;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.NamedDataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.NamedDataFieldSource;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;
import ru.yandex.misc.bender.annotation.Bendable;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author tolmalev
 */
@ProtoMessage
@Bendable
public class ProtobufDataField extends DefaultObject implements NamedDataFieldSource {
    @ProtoField(n = 1)
    public final String fieldId;

    @ProtoField(n = 2)
    private ProtobufDataFieldValue value;

    public ProtobufDataField(String fieldId, DataField field) {
        this.fieldId = fieldId;
        this.value = ProtobufDataFieldValue.cons(field);
    }

    public DataField toDataField() {
        return value.toDataField();
    }

    @Override
    public NamedDataField toNamedDataField() {
        return new NamedDataField(fieldId, toDataField());
    }
}
