package ru.yandex.chemodan.app.dataapi.api.data.protobuf;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.commune.protobuf5.annotation.ProtoMessage;

/**
 * @author tolmalev
 */
@ProtoMessage
public class ProtobufDataRecord {
    @ProtoField(n = 1)
    public final String collectionId;
    @ProtoField(n = 2)
    public final String recordId;
    @ProtoField(n = 3)
    public final long rev;
    @ProtoField(n = 4)
    public final ListF<ProtobufDataField> fields;

    public ProtobufDataRecord(String collectionId, String recordId, long rev, ListF<ProtobufDataField> fields) {
        this.collectionId = collectionId;
        this.recordId = recordId;
        this.rev = rev;
        this.fields = fields;
    }

    public ProtobufDataRecord(DataRecord record) {
        this(record.getCollectionId(), record.getRecordId(), record.rev, record.consProtobufFields());
    }

    public DataRecord toDataRecord(DataApiUserId uid, DatabaseHandle handle) {
        return toDataRecord(uid, new DataRecordId(handle, collectionId, recordId));
    }

    public DataRecord toDataRecord(DataApiUserId uid, DataRecordId recordId) {
        return new DataRecord(uid, recordId, rev, DataFields.fromFieldsSource(fields));
    }
}
