package ru.yandex.chemodan.app.dataapi.api.data.protobuf;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecordId;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.protobuf5.Protobuf5Serializer;
import ru.yandex.misc.io.InputStreamSource;

/**
 * @author tolmalev
 */
public class ProtobufDataUtils {
    public static final Protobuf5Serializer<ProtobufDataRecord> dataRecordSerializer =
            Protobuf5Serializer.cons(ProtobufDataRecord.class);

    public static final Protobuf5Serializer<Delta> deltaSerializer =
            Protobuf5Serializer.cons(Delta.class);

    public static final Protobuf5Serializer<SnapshotPojo> snapshotPojoSerializer =
            Protobuf5Serializer.cons(SnapshotPojo.class);

    public static byte[] serialize(Snapshot snapshot) {
        return snapshotPojoSerializer.serialize(snapshot.toPojo());
    }

    public static byte[] serialize(DataRecord record) {
        return dataRecordSerializer.serialize(new ProtobufDataRecord(record));
    }

    public static DataRecord parse(DataApiUserId uid, DatabaseHandle handle, byte[] rawRecord) {
        return dataRecordSerializer.deserialize(rawRecord)
                .toDataRecord(uid, handle);
    }

    public static DataRecord parse(DataApiUserId uid, DataRecordId recordId, byte[] rawRecord) {
        return dataRecordSerializer.deserialize(rawRecord)
                .toDataRecord(uid, recordId);
    }

    public static ListF<DataRecord> parse(DataApiUserId uid, DatabaseHandle handle, ListF<byte[]> rawRecords) {
        return rawRecords.map(dataRecordSerializer::deserialize)
                .map(protoRecord -> protoRecord.toDataRecord(uid, handle));
    }

    public static ListF<DataRecord> parse(DataApiUserId uid, DataRecordId recordId, ListF<byte[]> rawRecords) {
        return rawRecords.map(dataRecordSerializer::deserialize)
                .map(protoRecord -> protoRecord.toDataRecord(uid, recordId));
    }

    public static byte[] serialize(Delta delta) {
        return deltaSerializer.serialize(delta);
    }

    public static Delta parseDelta(byte[] serializedDelta) {
        return deltaSerializer.deserialize(serializedDelta);
    }

    public static Delta parseDelta(InputStreamSource iss) {
        return deltaSerializer.deserialize(iss.readBytes());
    }

    public static Function<byte[], Delta> parseDeltaF() {
        return ProtobufDataUtils::parseDelta;
    }

    public static Function<Delta, byte[]> serializeDeltaF() {
        return ProtobufDataUtils::serialize;
    }

    public static Snapshot deserializeSnapshot(byte[] snapshotData, DataApiUserId uid, DatabaseHandle handle) {
        return snapshotPojoSerializer.deserialize(snapshotData)
                    .toDomainObject(uid, handle.dbRef());
    }
}
