package ru.yandex.chemodan.app.dataapi.api.data.protobuf;

import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

import ru.yandex.commune.protobuf5.annotation.ProtoField;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
public class ProtobufDateTime extends DefaultObject {
    @ProtoField(n = 1)
    public final long instantMillisUtc;
    @ProtoField(n = 2)
    public final int offsetMillis;

    public ProtobufDateTime(DateTime dateTime) {
        this.instantMillisUtc = dateTime.getMillis();
        this.offsetMillis = dateTime.getZone().getOffset(dateTime);
    }

    public DateTime toDateTime() {
        return new DateTime(instantMillisUtc, DateTimeZone.forOffsetMillis(offsetMillis));
    }

    public static ProtobufDateTime fromDateTime(DateTime dateTime) {
        return new ProtobufDateTime(dateTime);
    }
}
